Ext.data.JsonP.sol_common_IniFile({"tagname":"class","name":"sol.common.IniFile","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"requires":true,"uses":true,"members":true,"code_type":true},"files":[{"filename":"lib_sol.common.FileUtils.js","href":"lib_sol.common.FileUtils.html#sol-common-IniFile"}],"elojc":true,"eloas":true,"eloix":true,"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":[],"requires":[],"uses":[],"members":[{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"bom","tagname":"property","owner":"sol.common.IniFile","id":"property-bom","meta":{"private":true}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"getSection","tagname":"method","owner":"sol.common.IniFile","id":"method-getSection","meta":{"private":true}},{"name":"getSectionName","tagname":"method","owner":"sol.common.IniFile","id":"method-getSectionName","meta":{"private":true}},{"name":"getValue","tagname":"method","owner":"sol.common.IniFile","id":"method-getValue","meta":{"private":true}},{"name":"initialize","tagname":"method","owner":"sol.common.IniFile","id":"method-initialize","meta":{"private":true}},{"name":"parse","tagname":"method","owner":"sol.common.IniFile","id":"method-parse","meta":{}},{"name":"setValue","tagname":"method","owner":"sol.common.IniFile","id":"method-setValue","meta":{"private":true}},{"name":"stringify","tagname":"method","owner":"sol.common.IniFile","id":"method-stringify","meta":{"private":true}}],"code_type":"ext_define","id":"class-sol.common.IniFile","classIcon":"icon-class","superclasses":["sol.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.common.IniFile</strong></div></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common.FileUtils.html#sol-common-IniFile' target='_blank'>lib_sol.common.FileUtils.js</a></div></pre><div class='doc-contents'><p>Represents an Ini file</p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-requiredConfig' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-bom' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.IniFile'>sol.common.IniFile</span><br/><a href='source/lib_sol.common.FileUtils.html#sol-common-IniFile-property-bom' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.IniFile-property-bom' class='name expandable'>bom</a> : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>&quot;\\uFEFF&quot;</code></p></div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n<p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-property-logger\" rel=\"sol.common.ix.FunctionBase-property-logger\" class=\"docClass\">sol.common.ix.FunctionBase.logger</a>, <a href=\"#!/api/sol.common.ix.ServiceBase-property-logger\" rel=\"sol.common.ix.ServiceBase-property-logger\" class=\"docClass\">sol.common.ix.ServiceBase.logger</a></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-getSection' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.IniFile'>sol.common.IniFile</span><br/><a href='source/lib_sol.common.FileUtils.html#sol-common-IniFile-method-getSection' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.IniFile-method-getSection' class='name expandable'>getSection</a>( <span class='pre'>sectionName</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sectionName</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-getSectionName' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.IniFile'>sol.common.IniFile</span><br/><a href='source/lib_sol.common.FileUtils.html#sol-common-IniFile-method-getSectionName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.IniFile-method-getSectionName' class='name expandable'>getSectionName</a>( <span class='pre'>line</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>line</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-getValue' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.IniFile'>sol.common.IniFile</span><br/><a href='source/lib_sol.common.FileUtils.html#sol-common-IniFile-method-getValue' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.IniFile-method-getValue' class='name expandable'>getValue</a>( <span class='pre'>sectionName, key</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sectionName</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>key</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-initialize' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.IniFile'>sol.common.IniFile</span><br/><a href='source/lib_sol.common.FileUtils.html#sol-common-IniFile-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.IniFile-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n\n\n\n</div></li></ul><p>Overrides: <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a></p></div></div></div><div id='method-parse' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.IniFile'>sol.common.IniFile</span><br/><a href='source/lib_sol.common.FileUtils.html#sol-common-IniFile-method-parse' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.IniFile-method-parse' class='name expandable'>parse</a>( <span class='pre'>content</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Parses an INI file ...</div><div class='long'><p>Parses an INI file</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>content</span> : String<div class='sub-desc'><p>Content</p>\n</div></li></ul></div></div></div><div id='method-setValue' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.IniFile'>sol.common.IniFile</span><br/><a href='source/lib_sol.common.FileUtils.html#sol-common-IniFile-method-setValue' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.IniFile-method-setValue' class='name expandable'>setValue</a>( <span class='pre'>sectionName, key, value</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sectionName</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>key</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>value</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-stringify' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.IniFile'>sol.common.IniFile</span><br/><a href='source/lib_sol.common.FileUtils.html#sol-common-IniFile-method-stringify' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.IniFile-method-stringify' class='name expandable'>stringify</a>( <span class='pre'></span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>ByteOrderMark (BOM) ...</div><div class='long'><p>ByteOrderMark (BOM)</p>\n</div></div></div></div></div></div></div>","meta":{"eloas":true,"eloix":true,"elojc":true}});